define(function (require) {
	'use strict';

	var socket = window.socket;
	var CommonHelper = require('app/helpers/common');

	var GameModel = require('app/models/game');
	var GameUserModel = require('app/models/game_user');

	var ConnectGameView = require('app/views/client/connect');
	var WaitView = require('app/views/client/wait');
	var GameQuestionView = require('app/views/client/question');
	var GameAfterQuestionView = require('app/views/client/after_question');
	var AnswerAcceptedView = require('app/views/client/answer_accepted');
	var DeadView = require('app/views/client/dead');
	var GameFinishedView = require('app/views/client/finished');
	var DisconnectedView = require('app/views/client/disconnected');

	return function () {

		$('body').addClass('screen-client');

		var game = new GameModel();

		var currentScreen = new ConnectGameView({});
		currentScreen.render().html();

		socket
			.on('game-joined', function(data){
				game.set(data.game);
				currentScreen = new WaitView({model: game});
				currentScreen.render().html();

				var user = data.user;
				game.setMe(new GameUserModel(user));
			})
			.on('game-pre-question', function (data) {
				if(!game.getMeUser().get('isDead')){
					game.set(data.game);
					currentScreen = new WaitView({game: game.set(data.game)});
					currentScreen.render().html();
				}
			})
			.on('game-question', function (data) {
				if(!game.getMeUser().get('isDead')){
					game.set(data.game);
					currentScreen = new GameQuestionView({game: game.set(data.game)});
					currentScreen.render().html();
				}
			})
			.on('answer-accepted', function(data){
				game.set(data.game);

				if(data.user.id == game.getMeUser().get('id')){
					// My answer was accepted.
					currentScreen = new AnswerAcceptedView({game: game});
					currentScreen.render().html();
				}
			})
			.on('game-after-question', function (data) {
				if(!game.getMeUser().get('isDead')){
					game.set(data.game);

					currentScreen = new GameAfterQuestionView({game: game});
					currentScreen.render().html();
				}
			})
			.on('you-died', function(data){
				game.set(data.game);

				currentScreen = new DeadView();
				currentScreen.render().html();
			})
			.on('game-showing-winners', function (data) {
				game.set(data.game);

				currentScreen = new GameFinishedView({game: game});
				currentScreen.render().html();
			})
			.on('game-message', function (data) {
				CommonHelper.msg(data.message, {type: data.type || 'info'});
			})
			.on('error', function (data) {
				CommonHelper.errorMsg(data.message);
			})
			.on('disconnect', function (data) {

				currentScreen = new DisconnectedView({game: game});
				currentScreen.render().html();
			})
			.on('game-destoyed', function(){
				// game destroyed.
				window.location.reload();
			})
	};
});